/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common;

import com.blackgear.platform.common.events.EntityEvents;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.core.data.tags.RCEntityTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;

public class CommonGameEvents {
    private static final int NORMAL_DIFFICULTY_CHANCE = 4;
    private static final int HARD_DIFFICULTY_CHANCE = 2;

    public static void bootstrap() {
        CommonGameEvents.registerConversionEvents();
    }

    private static void registerConversionEvents() {
        EntityEvents.ON_DEATH.register((entity, source) -> {
            Mob mob;
            if (entity instanceof Mob && CommonGameEvents.rollConversionChance(mob = (Mob)entity)) {
                CommonGameEvents.attemptEnvironmentalConversion(mob);
            }
            return true;
        });
    }

    private static boolean rollConversionChance(Mob mob) {
        Difficulty difficulty = mob.level().getDifficulty();
        if (difficulty == Difficulty.NORMAL) {
            return mob.getRandom().nextInt(4) == 0;
        }
        if (difficulty == Difficulty.HARD) {
            return mob.getRandom().nextInt(2) == 0;
        }
        return false;
    }

    private static void attemptEnvironmentalConversion(Mob mob) {
        if (mob.isInLava() && mob.getType().is(RCEntityTypeTags.CAN_CONVERT_TO_BURNED)) {
            CommonGameEvents.convertMob(mob, RCEntityTypes.BURNED.get());
            return;
        }
        if ((mob.isInPowderSnow || mob.wasInPowderSnow) && mob.getType().is(RCEntityTypeTags.CAN_CONVERT_TO_FROSTBITTEN)) {
            CommonGameEvents.convertMob(mob, RCEntityTypes.FROSTBITTEN.get());
        }
    }

    private static void convertMob(Mob mob, EntityType<? extends Mob> type) {
        mob.convertTo(type, true);
        if (!mob.isSilent()) {
            mob.level().levelEvent(1026, mob.blockPosition(), 0);
        }
    }
}

